clc
clear all
close all
set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');
all_marks = {'o','+','*','.','x','s','d','^','v','>','<','p','h'};

%% lettura dati e plot 
% dati
dratio=[0.2 0.3 0.4 0.5 0.7 1 2]*10;
p_transizione=2.6*10^5;

for index_d_ratio=1:length(dratio)
    d=dratio(index_d_ratio);
    dati=['load h0_project_Ps5_h10_dratio' num2str(d)];
    eval(dati)
    
    figure(1)
    plot(P1id, xid*1e6, 'linewidth',2)
    xlabel('Pressure $\quad P_{1,id} \quad (Pa)$','interpreter','Latex')
    ylabel('Distance $\quad x_{id} \quad(\mu m) $','interpreter','Latex')
    hold on
    mylegend{index_d_ratio}=['$d_{ratio}=\:$', num2str(dratio(index_d_ratio)/10)];
    titleText = ['$x_{id}$ vs $P_{1,id}$ \quad con \quad $h_{des} \: = \:$' num2str(round(abs(h_des))) '$\: \mu m$ \quad $ P_{s} \: = \:$ 4 $\: bar$'];
    title(titleText,'Interpreter','Latex','FontSize',32,'FontName','Times New Roman' );
end
legend(mylegend,'Location','northwest','FontSize',25,'FontName','Times New Roman','interpreter', 'Latex');
xlim([P1id(1) P1id(end)])
% plot(p_transizione,xid,'k--','LineWidth',2)